


(defun mi-plot (plot1 plot2)
(defmeth  missing-data-model-object-proto  :compute-limits (content-variables)
  (let* ((list-datasets (send self :multiple-imputed-datasets-list))
         (list-data-matrix (mapcar #'(lambda (obj) (select (column-list (send obj :data-matrix)) content-variables))
                                   list-datasets))
         (num-datasets (length (send self :multiple-imputed-datasets-list)))
        (num-variables (length content-variables))
         (ncase (array-dimension (send (first (send self :multiple-imputed-datasets-list)) :data-matrix) 0))
         (rows
          (mapcar #'(lambda (i) 
                   (row-list (apply 'bind-columns 
                                    (mapcar #'(lambda (datamatrix) (select datamatrix i))
                                            list-data-matrix))))
                    (iseq num-variables)))
         (means (mapcar #'(lambda (var) (mapcar #'(lambda (case) 
                                                    (if (variancep case) 
                                                        (mean case)
                                                        nil))
                                                var))
                        rows))
         (difs (mapcar #'(lambda (var means-var) (mapcar #'(lambda (case mean-case) 
                                                        (if (variancep case) 
                                                            (* 4  (sqrt 
                                                                    (/ (sum (** (- case mean-case) 2))
                                                                               (- num-datasets 1)))) ;intervals of 2 standard deviations
                                                            0))
                                               var means-var))
                              rows means))

         )
   (list difs means) ))

(defmeth missing-data-model-object-proto :add-boxes (plot &optional (current-variables nil))
  (let* ((plot plot)
         (variables (if current-variables current-variables (send plot :current-variables)))
         (means-and-errors (send self :compute-limits variables))
         (means (second means-and-errors))
         (limits (first means-and-errors))
         )
    (mapcar #'(lambda (i m1 m2) 
                (when m1 
                      (send plot :point-coordinate '0 i m1))
                (when m2 
                      (send plot :point-coordinate '1 i m2)))
           (iseq (length (first means))) (first means) (second means))
    (print means)
    (send plot :redraw)
    (symbol :plot plot :type 'diamonds-no-h-line  
            :heigths (second limits)
            :widths (first limits)
            ; :shapes shapes
            :modify-methods t)
   limits ))
                           
                      
                  
   (defmeth symbol-graph :draw-diamonds-no-h-line (&optional pts)
  (let* (
         (plot (send self :plot))
         (pts (if pts (combine pts) (iseq (send plot :num-points))))
         (x-coords (send plot :point-coordinate '0 pts))
         (y-coords (send plot :point-coordinate '1 pts))
         (real (1- (mapcar #'(lambda (x y) 
                           (send plot :real-to-canvas x y)
                           )
                       x-coords y-coords)))
         (half-heights (mapcar #'(lambda (h)
                                   (second
                                    (- (send plot :real-to-canvas 0 (abs h)) 
                                       (send plot :real-to-canvas 0 0))
                                    ))
                                      (/ (select (send self :heigths) pts) 2)))
         (half-widths (mapcar #'(lambda (w)
                                   (first
                                    (- (send plot :real-to-canvas (abs w) 0) 
                                       (send plot :real-to-canvas 0 0))
                                    ))
                                      (/ (select (send self :widths) pts) 2)))
         (lower-limits (mapcar #'(lambda (r h) (- (second r) h)) real half-heights))
         (upper-limits (mapcar #'(lambda (r h) (+ (second r) h)) real half-heights))
         (left-limits (mapcar #'(lambda (r w) (- (first r) w)) real half-widths))
         (right-limits (mapcar #'(lambda (r w) (+ (first r) w)) real half-widths))
         (selection (send plot :point-selected pts))
         (hilited (send plot :point-hilited pts))
         (showing (send plot :point-showing pts))
         (point-color (send plot :point-color pts))
         (witdh-point nil)
         (length-tick  (abs (first 
                             (- (send plot :canvas-to-real 2 1) 
                                (send plot :canvas-to-real 0 1))))))
          (mapcar #'(lambda (r u l left right select hil show pt-color)
                      
                      (when show
                            (when (or select hil)
                                  (setf prev-width (send plot :line-width))
                                  (send plot :line-width 1))
                            (setf prev-color (send plot :draw-color))
                            (when pt-color (send plot :draw-color pt-color))
                            (send plot :draw-color 'blue)
                         #|   (when (> (- right left) 0)
                                  (send plot :draw-line left (second r) 
                                        (- (+ left (round (/ (- right left) 2))) 2) (second r))
                                  (send plot :draw-line 
                                        (+ (+ left (round (/ (- right left) 2))) 2)  
                                        (second r) 
                                        (1+ right)
                                        (second r)) 
                                  )|#;no draws horizontal lines
                            
                            (when (or select hil)
                                  #|(when (equal pt-color 'red)
                                        :paint-oval 
                                        (send self :canvas-to-real 0 0)
                                        (send self :canvas-to-real 100 100))|#
                                 ; (when (not (equal pt-color 'red))
                                        (send plot :draw-line left (second r) (first r) u)   
                                        (send plot :draw-line (first r) u right (second r))
                                        (send plot :draw-line right (second r) (first r) l)
                                        (send plot :draw-line (first r) l left (second r)))
                                  ;)
                            ;(send plot :draw-color 'red)
                            (send plot :draw-color prev-color)
                            (when (or select hil) 
                                  (send plot :line-width prev-width))
                            ))
                  real upper-limits lower-limits left-limits right-limits selection hilited showing point-color)
          ))

(defmeth symbol-graph :draw-symbol (&optional points)
  (when (> (send (send self :plot) :num-points) 0)
        (cond 
          ((equal (send self :type) 'vertical-line) 
           (send self :draw-vertical-line)
           )
          ((equal (send self :type) 'vertical-line-with-ticks)
           (send self :draw-vertical-line-ticks))
          ((equal (send self :type) 'vertical-line-with-ticks-when-selected)
           (send self :draw-vertical-line-ticks-when-selected))
          ((equal (send self :type) 'diamonds)
           (send self :draw-diamonds points))
          ((equal (send self :type) 'diamonds-no-h-line)
           (send self :draw-diamonds-no-h-line points))
          ))
  )

(send current-model :add-boxes (third  (send *current-spreadplot* :all-plots)) (list plot1 plot2))   
)

;(send current-model :add-boxes a (list 4 10)) 

#|(sp)

(defun sp ()
(setf xx    (third (send *current-spreadplot* :all-plots)))
    (send xx :range '0 -0.5 6)
    (send xx :size 250 250)
    (send xx :pop-out t)
    (send xx :ask-save-pdf))|#